/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.scope;

import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigContextMenu;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigRootNode;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.scope.VWConfigScopeTree;
import filenet.vw.toolkit.design.canvas.config.VWDesignerRegionNode;
import filenet.vw.toolkit.design.canvas.config.VWDesignerVWServiceNode;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class VWScopeTreeMouseAdapter
extends MouseAdapter {
    private ActionListener m_listener = null;
    private VWConfigScopeTree m_scopeTree = null;
    private VWConfigBaseNode m_focus = null;
    private VWConfigContextMenu m_mi = null;
    private VWSessionInfo m_vwSessionInfo = null;

    public VWScopeTreeMouseAdapter(ActionListener listener, VWConfigScopeTree scopeTree) {
        this.m_listener = listener;
        this.m_scopeTree = scopeTree;
        this.m_focus = (VWConfigBaseNode)this.m_scopeTree.getModel().getRoot();
        this.m_vwSessionInfo = this.m_focus.getSessionInfo();
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        } else {
            int selRow = this.m_scopeTree.getRowForLocation(event.getX(), event.getY());
            this.m_scopeTree.setSelectionRow(selRow);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            Point p = event.getPoint();
            if (this.m_scopeTree.getPathForLocation(p.x, p.y) != null) {
                VWConfigRegionNode rNode;
                int nodeType = this.m_focus.getType();
                if (nodeType == 1 || nodeType == 2) {
                    this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_QUEUE_PROPERTIES));
                } else if (nodeType == 5) {
                    this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_COMPONENT_PROPERTIES));
                } else if (nodeType == 3) {
                    this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_ROSTER_PROPERTIES));
                } else if (this.m_focus.getType() == 4) {
                    this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_EVENTLOG_PROPERTIES));
                } else if (this.m_focus.getType() == 6) {
                    this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_APPSPACE_PROPERTIES));
                } else if (nodeType == 19 && (rNode = (VWConfigRegionNode)this.m_focus).getSessionInfo() == null) {
                    this.m_listener.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_LOGON));
                }
            }
        }
    }

    protected void setFocus(VWConfigBaseNode node) {
        this.m_focus = node;
    }

    private void showPopup(MouseEvent event) {
        TreePath selPath = this.m_scopeTree.getPathForLocation(event.getX(), event.getY());
        if (selPath == null) {
            return;
        }
        String actionCmd = this.m_focus.getActionCommandString();
        if (actionCmd == null) {
            return;
        }
        if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 17, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_CONSOLE_ROOT) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 0, this.m_listener, this.m_focus);
            this.m_mi.setRootMenus((VWConfigRootNode)this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_SYSTEM) == 0) {
            VWConfigVWServiceNode svcNode = (VWConfigVWServiceNode)this.m_focus;
            if (svcNode != null && svcNode instanceof VWDesignerVWServiceNode) {
                return;
            }
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 1, this.m_listener, this.m_focus);
            this.m_mi.setSystemMenus((VWConfigVWServiceNode)this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_REGION) == 0) {
            VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus;
            if (rNode.getSessionInfo() == null) {
                this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 5, this.m_listener, this.m_focus);
            } else {
                this.m_mi = rNode instanceof VWDesignerRegionNode ? new VWConfigContextMenu(rNode.getSessionInfo(), 3, this.m_listener, this.m_focus) : new VWConfigContextMenu(rNode.getSessionInfo(), 2, this.m_listener, this.m_focus);
                this.m_mi.setRegionMenus((VWConfigRegionNode)this.m_focus);
            }
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_SERVER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 4, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_COMP_QUEUE_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 6, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_USER_QUEUE_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 8, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_WORK_QUEUE_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 7, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_WORK_QUEUE) == 0 || VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_USER_QUEUE) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 13, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_COMP_QUEUE) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 12, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_ROSTER_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 9, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_ROSTER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 14, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_EVENTLOG_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 10, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_EVENTLOG) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 15, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_APPSPACE_FOLDER) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 11, this.m_listener, this.m_focus);
        } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_APPSPACE) == 0) {
            this.m_mi = new VWConfigContextMenu(this.m_vwSessionInfo, 16, this.m_listener, this.m_focus);
        }
        if (this.m_mi != null) {
            Object obj = event.getSource();
            Point p = event.getPoint();
            this.m_mi.show((JTree)obj, p.x, p.y);
        }
    }

    protected void releaseResources() {
        if (this.m_mi != null) {
            this.m_mi.releaseResources();
            this.m_mi = null;
        }
        this.m_listener = null;
        this.m_scopeTree = null;
        this.m_focus = null;
    }
}

